/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.data.PlayerMail;

public class PlayerMailData {
    public final List<PlayerMail> playerMails = new ArrayList<PlayerMail>();

    public void addMail(PlayerMail mail) {
        mail = mail.copy();
        mail.timeWhenReceived = System.currentTimeMillis();
        if (mail.timeWhenReceived <= 0L) {
            mail.timeWhenReceived = 100000L;
        }
        mail.timeWillCome = 1000L * ((long)CustomNpcs.MailTimeWhenLettersWillBeReceived[0] + (long)(Math.random() * (double)(CustomNpcs.MailTimeWhenLettersWillBeReceived[1] - CustomNpcs.MailTimeWhenLettersWillBeReceived[0])));
        boolean found = true;
        block0: while (found) {
            found = false;
            for (PlayerMail m : this.playerMails) {
                if (m.timeWhenReceived != mail.timeWhenReceived) continue;
                --mail.timeWhenReceived;
                found = true;
                continue block0;
            }
        }
        this.playerMails.add(mail);
    }

    public PlayerMail get(long id) {
        for (PlayerMail mail : this.playerMails) {
            if (mail.timeWhenReceived != id) continue;
            return mail;
        }
        return null;
    }

    public PlayerMail get(PlayerMail selected) {
        for (PlayerMail mail : this.playerMails) {
            if (mail.timeWhenReceived != selected.timeWhenReceived || !mail.getSubject().equals(selected.getSubject())) continue;
            return mail;
        }
        return null;
    }

    public boolean hasMail() {
        for (PlayerMail mail : this.playerMails) {
            if (mail.beenRead) continue;
            return true;
        }
        return false;
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("MailData", 10);
        this.playerMails.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            PlayerMail mail = new PlayerMail();
            mail.readNBT(list.func_150305_b(i));
            this.playerMails.add(mail);
        }
    }

    public NBTTagCompound saveNBTData(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (PlayerMail mail : this.playerMails) {
            list.func_74742_a((NBTBase)mail.writeNBT());
        }
        compound.func_74782_a("MailData", (NBTBase)list);
        return compound;
    }
}

